#!/bin/bash
# Mindtime Online Backup Pro Manager 6.13.4.0

# --------------------------- Change to AUA_HOME -------------------------------
AUA_BIN=`dirname "$0"`
cd "${AUA_BIN}"

cd ..
AUA_HOME=`pwd`

# ----------------- Setup the IPC directory ------------------------------------
# Check if IPC directory exist
if [ ! -e "./ipc" ]
  then mkdir "./ipc"
fi
# Allow all clients to access the ipc directory
chmod 777 "./ipc"

if [ ! -e "./ipc/xmlchannel" ]
  then mkdir "./ipc/xmlchannel"
fi
# Allow all clients to access the xmlchannel
chmod 777 "./ipc/xmlchannel"

# ----------------- Setup the Config file permission ---------------------------
# Allow all clients to update the config file
chmod 777 "./config.xml"

# ----------------- Remove the last created Property file ----------------------
# Remove the last created local-machine.properties file
if [ -e "./builds/local-machine.properties" ]
  then rm "./builds/local-machine.properties"
fi

# -------------------------- Set the Build Filename ----------------------------
AUA_BUILD_FILENAME=aua-check-properties.xml

# ------------------- ApacheANT Execution via Java -----------------------------
AUA_ANT_CLASSPATH=./ant/lib/ant.jar:./ant/lib/ant-launcher.jar:./ant/lib/xercesImpl.jar:./ant/lib/xml-apis.jar      

# Run ApacheANT with AutoUpdateAgent JVM
"${AUA_HOME}/jvm/bin/java" -Xrs -Dant.home=./ant -cp ${AUA_ANT_CLASSPATH} org.apache.tools.ant.launch.Launcher -f ./builds/${AUA_BUILD_FILENAME}
