#!/bin/sh
# Mindtime Online Backup Pro Manager 6.13.4.0

##############################  ListBackupSet.sh  ##############################
# You can use this shell script to list all backup sets available under        #
# your backup account.                                                         #
################################################################################

########################  Start: User Defined Section  #########################

# ------------------------------  SETTING_HOME  --------------------------------
# | Directory to your setting home.                                            |
# | Default to ${HOME}/.obm when not set.                                      |
# | e.g. SETTING_HOME="${HOME}/.obm"                                           |
# ------------------------------------------------------------------------------
SETTING_HOME=""

##########################  END: User Defined Section  #########################

################################################################################
#         R E T R I E V E            A P P _ H O M E           P A T H         #
################################################################################

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

################################################################################
#         R E T R I E V E           J A V A _ H O M E           P A T H        #
################################################################################

if [ Darwin = `uname` ]; then
    JAVA_HOME=/System/Library/Frameworks/JavaVM.framework/Home
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "$APP_HOME/jvm does not exist!"
    if [ ! -n "$JAVA_HOME" ]; then
        echo "Please set JAVA_HOME!"
        exit 0
    else
        ln -sf "$JAVA_HOME" "$APP_HOME/jvm"
        echo "Created JAVA_HOME symbolic link at $APP_HOME/jvm"
    fi
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "Please create symbolic link for '$JAVA_HOME' to '$APP_HOME/jvm'"
    exit 0
fi

JAVA_HOME="$APP_HOME/jvm"
JAVA_EXE="$JAVA_HOME/bin/java"

################################################################################
#                  J A V A                 E X E C U T I O N                   #
################################################################################

# Change to APP_HOME for JAVA execution
cd "${APP_HOME}"

# Reference path will be used to avoid empty space in the parent directory
LIB_HOME=./bin
JAVA_OPTS="-Xms128m -Xmx768m -client"
JNI_PATH="-Djava.library.path=$LIB_HOME"
CLASSPATH="$LIB_HOME:$LIB_HOME/obc.jar:$LIB_HOME/obc-lib.jar"
MAIN_CLASS=ListBackupSet

echo "Using APP_HOME     : ${APP_HOME}"
echo "Using SETTING_HOME : ${SETTING_HOME}"

# API Arguments: ListBackupSet [APP_HOME] [SETTING_HOME]

# Do not include double-quote for java options, jni path, classpath and main class
# Only apply double-quote for path to java executable and execution arguments
"${JAVA_EXE}" $JAVA_OPTS $JNI_PATH -cp $CLASSPATH $MAIN_CLASS "${APP_HOME}" "${SETTING_HOME}"

################################################################################
#                   R E S E T          A N D          E X I T                  #
################################################################################

cd "${EXE_DIR}"
exit 0
