#!/bin/sh
# Mindtime Online Backup Pro Manager 6.13.4.0

################################## RunOBC.sh ###################################
# You can use this shell to run the application without AutoUpdate             #
################################################################################

######################### START: User Defined Section ##########################

# ------------------------------------------------------------------------------
# | Enable/Disable debug mode                                                  |
# | e.g. DEBUG_MODE="--debug"                                                  |
# |  or  DEBUG_MODE=""                                                         |
# ------------------------------------------------------------------------------
DEBUG_MODE=""

# ------------------------------------------------------------------------------
# |          R E T R I E V E     S E T T I N G _ H O M E     P A T H           |
# | Directory to your setting home.                                            |
# | Default to ${HOME}/.obm when not set.                                      |
# | e.g. SETTING_HOME=${HOME}/.obm                                             |
# ------------------------------------------------------------------------------
SETTING_HOME=""

########################## END: User Defined Section ###########################


################################################################################
#          R E T R I E V E     A P P _ H O M E     P A T H                     #
################################################################################

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

################################################################################
#          R E T R I E V E     J A V A _ H O M E     P A T H                   #
################################################################################

if [ Darwin = `uname` ]; then
    JAVA_HOME=/System/Library/Frameworks/JavaVM.framework/Home
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "$APP_HOME/jvm does not exist!"
    if [ ! -n "$JAVA_HOME" ]; then
        echo "Please set JAVA_HOME!"
        exit 0
    else
        ln -sf "$JAVA_HOME" "$APP_HOME/jvm"
        echo "Created JAVA_HOME symbolic link at $APP_HOME/jvm"
    fi
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "Please create symbolic link for '$JAVA_HOME' to '$APP_HOME/jvm'"
    exit 0
fi

JAVA_HOME="$APP_HOME/jvm"

# Use alternative executable name to define the GUI execution
if [ Darwin = `uname` ]; then
    JAVA_EXE="$JAVA_HOME/bin/java"
else
    JAVA_EXE="$JAVA_HOME/bin/bJW"
fi

################################################################################
#          S T A R T - U P     W I T H     U P D A T E     C H E C K           #
################################################################################

if [ "run" = "$1" ]; then
    RUN_BACKUP_MANAGER=true
fi

if [ -n "$RUN_BACKUP_MANAGER" -o ! -f "$APP_HOME/aua/auas-message.xml" ]; then
    # Set LD_LIBRARY_PATH for Lotus Notes on Linux
    if [ Linux = `uname` ]; then
        NOTES_PROGRAM=`cat "$APP_HOME/bin/notesenv"`
        LD_LIBRARY_PATH=$APP_HOME/bin:$NOTES_PROGRAM:$LD_LIBRARY_PATH
        export NOTES_PROGRAM
    else
        LD_LIBRARY_PATH=$APP_HOME/bin:$LD_LIBRARY_PATH
    fi
    SHLIB_PATH=$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH SHLIB_PATH

    # Change to APP_HOME for JAVA execution
    cd "${APP_HOME}"

    # Reference path will be used to avoid empty space in the parent directory
    LIB_HOME=./bin
    JAVA_OPTS="-Xrs -Xms128m -Xmx768m -client"
    JNI_PATH="-Djava.library.path=$LIB_HOME"
    CLASSPATH="$LIB_HOME:$LIB_HOME/obc.jar:$LIB_HOME/obc-lib.jar"
    MAIN_CLASS=obc

    # Execute Java VM Runtime for BackupManager
    echo "Startup BackupManager ... "
    "${JAVA_EXE}" $JAVA_OPTS $JNI_PATH -cp $CLASSPATH $MAIN_CLASS "${DEBUG_MODE}" "${APP_HOME}" "${SETTING_HOME}" &

else
    # Set Java VM Runtime Environment
    JAVA_OPTS="-Xrs -Xms128m -Xmx768m"
    CLASSPATH="$APP_HOME/aua/lib:$APP_HOME/aua/lib/jdom.jar:$APP_HOME/aua/lib/log4j.jar:$APP_HOME/aua/lib/aua.jar:$APP_HOME/aua/ant/lib/ant.jar:$APP_HOME/aua/ant/lib/ant-launcher.jar:$APP_HOME/aua/ant/lib/xercesImpl.jar:$APP_HOME/aua/ant/lib/xml-apis.jar"
    MAIN_CLASS=auac

    # Execute Java VM Runtime for AutoUpdateAgent Client
    echo "AutoUpdate Message is found, now process message."
    "$APP_HOME/aua/jvm/bin/java" $JAVA_OPTS -cp $CLASSPATH $MAIN_CLASS ./config.xml update

    # Execute Backup Client
    sh "$APP_BIN/RunOBC.sh" run &
fi

###############################################################################
#                   R E S E T          A N D          E X I T                 #
###############################################################################

cd "${EXE_DIR}"
exit 0
