#!/bin/bash

# uninstall logic for Mindtime Online Backup Pro Manager 6.13.4.0
# The root privilege is required to uninstall the application

###############################################################################
#             S H U T - D O W N                 S E R V I C E S               #
###############################################################################

# Shutdown Scheduler
if [ -e "/Applications/Mindtime Pro Backup/ipc/Scheduler/running" ]; then
    echo "Shutdown Scheduler for Mindtime Online Backup Pro Manager"
    touch "/Applications/Mindtime Pro Backup/ipc/Scheduler/stop"
    echo "Wait 5 seconds before Scheduler exits"
    sleep 5
fi

# Shutdown AutoUpdateAgent
if [ -e "/Applications/Mindtime Pro Backup/aua/bin" ]; then
    echo "Shutdown AutoUpdateAgent for Mindtime Online Backup Pro Manager"
    sh "/Applications/Mindtime Pro Backup/aua/bin/shutdown.sh"
    echo "Wait 5 seconds before AutoUpdateAgent exits"
    sleep 5
fi

###############################################################################
#        T A S K K I L L       A L L      J A V A       P R O C E S S         #
###############################################################################

# Kill all running process
sh "/Applications/Mindtime Pro Backup/bin/taskkill" "/Applications/Mindtime Pro Backup/BackupManager.app"
sh "/Applications/Mindtime Pro Backup/bin/taskkill" "/Applications/Mindtime Pro Backup/bin/BackupManager.app"
sh "/Applications/Mindtime Pro Backup/bin/taskkill" "/Applications/Mindtime Pro Backup/jvm/bin/java"
sh "/Applications/Mindtime Pro Backup/bin/taskkill" "/Applications/Mindtime Pro Backup/aua/jvm/bin/java"

###############################################################################
#                 R E M O V E                   S E R V I C E S               #
###############################################################################

# Remove Scheduler
if [ -e "/Library/StartupItems/MindtimeProBackup" ]; then
    echo "Remove Scheduler for Mindtime Online Backup Pro Manager from service"
    rm -rf "/Library/StartupItems/MindtimeProBackup"
fi

# Remove AutoUpdateAgent
if [ -e "/Library/StartupItems/MindtimeProBackup-AutoUpdate" ]; then
    echo "Remove AutoUpdateAgent for Mindtime Online Backup Pro Manager from service"
    rm -rf "/Library/StartupItems/MindtimeProBackup-AutoUpdate"
fi

###############################################################################
#      R E M O V E        U S E R         D E S K T O P      L I N K          #
###############################################################################

# Remove Desktop Symbolic Link
find /Users -name Desktop -type d -maxdepth 3 -mindepth 2 | while read DESKTOP_PATH;
do
    if [ -e "${DESKTOP_PATH}/MindtimeProBackup" ]; then
        echo "Remove Desktop Link MindtimeProBackup from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/MindtimeProBackup"
        echo "Removed Mindtime Online Backup Pro Manager Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/Mindtime Pro Backup" ]; then
        echo "Remove Desktop Link Mindtime Pro Backup from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/Mindtime Pro Backup"
        echo "Removed Mindtime Online Backup Pro Manager Desktop Link"
    fi
done

###############################################################################
#        R E M O V E           A P P L I C A T I O N           H O M E        #
###############################################################################

# Remove Mindtime Online Backup Pro Manager
cd /
if [ -e "/Applications/Mindtime Pro Backup" ]; then
    echo "Remove Mindtime Online Backup Pro Manager from Your Mac OS X"
    rm -rf "/Applications/Mindtime Pro Backup"
fi

###############################################################################
#        R E M O V E             M A C     O S        R E C E I P T S         #
###############################################################################

# Remove Mac OS X Receipts
if [ -e "/Library/Receipts/obm.pkg" ]; then
    echo "Remove Mac OS X Receipt for obm.pkg (Path: /Library/Receipts/obm.pkg)"
    rm -rf "/Library/Receipts/obm.pkg"
fi
