@ECHO OFF
SETLOCAL enabledelayedexpansion
SET APP_JVM_HOME=..\jvm
SET AUA_JVM_HOME=.\jvm
SET JVM_HOME=%APP_JVM_HOME%
IF "%~4"=="MIGRATE" (
  ECHO Use JVM home in AUA folder for migration
  SET JVM_HOME=%AUA_JVM_HOME%
) ELSE IF "%~3"=="UI" (
  ECHO Check if JVM for migration exists
  REM for CloudBacko case, check if update jvm file exists or not
  CALL copy-jvm.bat
  SET COPY_JVM_RESULT=!ERRORLEVEL!
  IF "!COPY_JVM_RESULT!"=="1" (
    ECHO Cannot extract JVM for migration. Exit now.
    EXIT 1
  ) ELSE IF "!COPY_JVM_RESULT!"=="0" (
    ECHO Use JVM home in AUA folder for migration
    SET JVM_HOME=%AUA_JVM_HOME%
  ) ELSE (
    ECHO No need to migrate JVM
  )
) ELSE (
  IF NOT "%~4"=="" (
    ECHO Use custom JVM home in AUA folder for migration
    SET JVM_HOME=%~4
  )
)

IF NOT Exist "%JVM_HOME%\bin\javau.exe" (
  ECHO Copy from "%JVM_HOME%\bin\java.exe" to "%JVM_HOME%\bin\javau.exe"
  copy "%JVM_HOME%\bin\java.exe" "%JVM_HOME%\bin\javau.exe"
)

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
  SET "DEP_LIB_PATH=X86"
) ELSE (
  SET "DEP_LIB_PATH=X64"
)
SET JAVA_LIB_PATH=-Djava.library.path=.\lib;.\lib\%DEP_LIB_PATH%

REM Load aua.ini only if JVM is java 21 or above, which has both conf and legal folders under JVM_HOME
SET JAVA_OPTS=-Xmx128m
IF Exist "%JVM_HOME%\conf" (
  IF Exist "%JVM_HOME%\legal" (
    SET INI_FILE=.\lib\aua.ini
    IF Exist "!INI_FILE!" (
      SET JAVA_OPTS=
      for /f "tokens=* delims=" %%A in ('findstr /V /R "^[#]" "!INI_FILE!"') do (
        set "line=%%A"
        if not "!line!"=="" set JAVA_OPTS=!JAVA_OPTS! !line!
      )
    )
  )
)
ECHO JAVA_OPTS="%JAVA_OPTS%"

ECHO Start update application process
"%JVM_HOME%\bin\javau" %JAVA_LIB_PATH% -cp .\lib;.\lib\aua.jar -Xrs %JAVA_OPTS% AuaI %1 %2 %~3
IF NOT "%ERRORLEVEL%"=="0" (
  ECHO Update not completed, terminate now
  EXIT 0
)
IF "%~3"=="UI" (
  REM Do not ECHO message here since it will cause UI not started
  RMDIR /S /Q "%AUA_JVM_HOME%"
  cd ..\bin
  IF "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
    START SystemTray64.exe -UI
  ) ELSE (
    IF "%PROCESSOR_ARCHITECTURE%"=="x64" (
      START SystemTray64.exe -UI
    ) ELSE (
      START SystemTray.exe -UI
    )
  )
)
