@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

REM get application home
SET "EXE_HOME=%CD%"
CD "%~dp0"
SET "APP_BIN=%CD%"
CD ".."
SET "APP_HOME=%CD%"
CD "%EXE_HOME%"
SET "SERVICE_UTIL=%APP_HOME%\util\bin\Service.exe"
IF NOT EXIST "%SERVICE_UTIL%" (
    SET "SERVICE_UTIL=%APP_BIN%\Service.exe"
    IF NOT EXIST "!SERVICE_UTIL!" (
        ECHO."No Service.exe could be found!"
        EXIT /B 1
    )
)

REM Define the service
REM WinXP
SET "WIN_VER=5.1"
SET "SERVICE_VER=0.6.0"
SET "FILESYS_VER=600"
VER | FIND "%WIN_VER%." > NUL
IF ERRORLEVEL = 1 GOTO _CHECK52
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK52
REM WinXP64, Server2003, Server2003R2
SET "WIN_VER=5.2"
VER | FIND "%WIN_VER%." > NUL
IF ERRORLEVEL = 1 GOTO _CHECK60
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK60
REM WinVista, Server2008
SET "WIN_VER=6.0"
VER | FIND "%WIN_VER%." > NUL
IF ERRORLEVEL = 1 GOTO _CHECK61
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK61
REM Win7, Server2008R2
SET "WIN_VER=6.1"
SET "SERVICE_VER=1.0.1"
SET "FILESYS_VER=100"
VER | FIND "%WIN_VER%." > NUL
IF ERRORLEVEL = 1 GOTO _CHECK62
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK62
REM Win8, Server2012
SET "WIN_VER=6.2"
VER | FIND "%WIN_VER%." > NUL
IF ERRORLEVEL = 1 GOTO _CHECK63
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK63
REM Win8.1, Server2012R2
SET "WIN_VER=6.3"
VER | FIND "%WIN_VER%." > NUL
IF ERRORLEVEL = 1 GOTO _CHECK100
IF ERRORLEVEL = 0 GOTO _CHECKED
:_CHECK100
REM Win10, Server2016
SET "WIN_VER=10.0"
VER | FIND "%WIN_VER%." > NUL
IF ERRORLEVEL = 1 GOTO _CHECKFAILED
IF ERRORLEVEL = 0 GOTO _CHECKED

:_CHECKFAILED
GOTO _NOT_SUPPORT

:_CHECKED
IF "%WIN_VER%"=="" (
    GOTO _NOT_SUPPORT
)

CD "%~dp0"
SET "QUERY_PATH=%CD%\VFSDriver.%SERVICE_VER%\Query.bat"
IF EXIST "%QUERY_PATH%" (
    GOTO _SUPPORT
)

:_NOT_SUPPORT
ECHO.This version of Windows is not supported!
ECHO.
CD "%EXE_HOME%"
EXIT /B 1

:_SUPPORT
ECHO.FSYS_VERSION: %FILESYS_VER%
ECHO.
CALL "%QUERY_PATH%" "%CD%" "%WIN_VER%" "%SERVICE_UTIL%"
CD "%EXE_HOME%"

ENDLOCAL
