param([string]$ruleName, [string]$programPath, [bool]$isCreate)

if ($(Get-NetFirewallRule DisplayName "$($ruleName) TCP" -ErrorAction SilentlyContinue) -And $(Get-NetFirewallRule DisplayName "$($ruleName) UDP" -ErrorAction SilentlyContinue)) {
	if (-Not $isCreate) {
		write-host "Removing existing rules..."
		Remove-NetFirewallRule -DisplayName "$($ruleName) TCP","$($ruleName) UDP"
	} else {
		write-host "Firewall rule for "$($ruleName) TCP" and "$($ruleName) UDP" already exist."
	}
} else {
	if ($isCreate) {
		write-host "Firewall rule for "$($ruleName) TCP" and "$($ruleName) UDP" does not exist, creating new rules now..."
		New-NetFirewallRule -DisplayName "$($ruleName) TCP" -Direction Inbound -Profile Domain,Private,Public -Action Allow -Protocol TCP -Program $programPath -RemoteAddress Any
		New-NetFirewallRule -DisplayName "$($ruleName) UDP" -Direction Inbound -Profile Domain,Private,Public -Action Allow -Protocol UDP -Program $programPath -RemoteAddress Any
		write-host "Firewall rules are created successfully"
	}
}
