@ECHO OFF
REM #################  delete-archive-logs.bat  ################################
REM # You can use this batch to delete all archived logs entry from RMAN       #
REM # database. The RMAN script file 'delete-archive-logs.rman' must also be   #
REM # saved in the same directory of this file for this script to function     #
REM # correctly. You can add this script as a post-backup command to delete    #
REM # all archived logs in the recovery catalog correctly to prevent the       #
REM # "ORA-00257 archiver error".                                              #
REM ############################################################################

REM ----------------------------  CONNECT_STRING  ------------------------------
REM | You must provide a valid connect string with system privileges           |
REM | to the oracle database.                                                  |
REM | e.g. SET CONNECT_STRING=sys/sys@orcl                                     |
REM ----------------------------------------------------------------------------
SET CONNECT_STRING=

REM --------------------------------  CATALOG  ---------------------------------
REM | The recovery catalog to connect to. Default to nocatalog                 |
REM | e.g. SET CATALOG=nocatalog                                               |
REM |  or  SET CATALOG=catalog RMAN/RMAN@OEMREP                                |
REM ----------------------------------------------------------------------------
SET CATALOG=nocatalog

REM --------------------------  LOG_RETENTION_DAYS  ----------------------------
REM | Number of days of logs to retain, older logs will be deleted             |
REM | e.g. LOG_RETENTION_DAYS=60                                               |
REM ----------------------------------------------------------------------------
SET LOG_RETENTION_DAYS=

REM ####################  END: User Defined Section  ###########################
SET CMDFILE=UpdateOracleRmanRecords.rman

REM ############################### Check config ###############################
IF NOT "%~1"=="" SET "CONNECT_STRING=%~1"
IF "%CONNECT_STRING%"=="" SET "CONNECT_STRING=/"
IF NOT "%~2"=="" SET "LOG_RETENTION_DAYS=%~2"
IF "%LOG_RETENTION_DAYS%"=="" SET "LOG_RETENTION_DAYS=60"

@ECHO ON
rman target %CONNECT_STRING% %CATALOG% cmdfile=%CMDFILE% '%LOG_RETENTION_DAYS%'