@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

REM get application home
SET "EXE_HOME=%CD%"
CD "%~dp0"

REM define query option
SET "TAG_QUERY_OPTION_SERVICE_NOT_IN_USE=serviceNotInUse"
SET "TAG_QUERY_OPTION_IS_SUPPORT_UPDATE_BY_INSTALLER=isSupportUpdateByInstaller"
SET "QUERY_OPTION=%~1"

REM define query result tag
SET "TAG_STATUS_UNKNOWN=Unknown"
SET "TAG_STATUS_NOT_INSTALL=NotInstall"
SET "TAG_STATUS_NOT_ACCESSIBLE=NotAccessible"
SET "TAG_STATUS_RUNNING=Running"
SET "TAG_STATUS_STOPPED=Stopped"

REM query service
SET "SERVICE_NAME=OBNfsServer"
SET "SERVICE_DISPLAY_NAME="
SET "SERVICE_DESCRIPTION="
SET "SERVICE_EXEC_PATH="
SET "SERVICE_STATUS=%TAG_STATUS_UNKNOWN%"
CALL :Sub_Query_Service

ECHO.Service Name:         %SERVICE_NAME%
ECHO.Service Display Name: %SERVICE_DISPLAY_NAME%
ECHO.Service Description:  %SERVICE_DESCRIPTION%
ECHO.Service Path:         %SERVICE_EXEC_PATH%
ECHO.Service Status:       %SERVICE_STATUS%

REM query NFS
SET "NFS_VERSION="
SET "NFS_STATUS=%TAG_STATUS_UNKNOWN%"
SET "NFS_NUM_MOUNT_POINT=-1"
SET "NFS_NUM_RUNNING_SESSION=-1"
CALL :Sub_Query_Nfs

ECHO.NFS Version:          %NFS_VERSION%
ECHO.NFS Status:           %NFS_STATUS%
ECHO.NFS Mount Point:      %NFS_NUM_MOUNT_POINT%
ECHO.NFS Running Session:  %NFS_NUM_RUNNING_SESSION%

REM process query option
SET /A "NFS_IN_USE=%NFS_NUM_MOUNT_POINT%"
IF %NFS_IN_USE% GTR 0 (
    SET "NFS_IN_USE=1"
) ELSE (
    SET "NFS_IN_USE=0"
)
SET "QUERY_EXIT_CODE=0"
IF "%TAG_QUERY_OPTION_SERVICE_NOT_IN_USE%"=="%QUERY_OPTION%" (
    IF "%TAG_STATUS_RUNNING%"=="%SERVICE_STATUS%" (
        SET "QUERY_EXIT_CODE=%NFS_IN_USE%"
    )
)
IF "%TAG_QUERY_OPTION_IS_SUPPORT_UPDATE_BY_INSTALLER%"=="%QUERY_OPTION%" (
    SET "QUERY_EXIT_CODE=1"
)

CD "%EXE_HOME%"
EXIT /B %QUERY_EXIT_CODE%
ENDLOCAL

REM ------------------------------------------------
:Sub_Left_Trim
FOR /f "tokens=* delims= " %%a IN ("%~1") DO (
    SET "%~2=%%a"
)

:Sub_Left_Trim_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Query_Service
SET "SERVICE_UTIL=Service.exe"

SET "SERVICE_LOGON="
FOR /f "tokens=*" %%i IN ('"%SERVICE_UTIL%" -n %SERVICE_NAME%') DO (
    SET "SERVICE_LOGON=%%i"
    GOTO Sub_Query_Service_Logon_End
)

:Sub_Query_Service_Logon_End
IF ""=="%SERVICE_LOGON%" (
    SET "SERVICE_STATUS=%TAG_STATUS_NOT_INSTALL%"
) ELSE (
    CALL :Sub_Query_Service_Tag "Displayname" SERVICE_DISPLAY_NAME
    CALL :Sub_Query_Service_Tag "Description" SERVICE_DESCRIPTION
    CALL :Sub_Query_Service_Tag "ImagePath" SERVICE_EXEC_PATH
    FOR /f "tokens=*" %%i IN ('"%SERVICE_UTIL%" -q %SERVICE_NAME%') DO (
        IF "SERVICE_RUNNING"=="%%i" (
            SET "SERVICE_STATUS=%TAG_STATUS_RUNNING%"
        )
        IF "SERVICE_STOPPED"=="%%i" (
            SET "SERVICE_STATUS=%TAG_STATUS_STOPPED%"
        )
        GOTO Sub_Query_Service_End
    )
)

:Sub_Query_Service_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Query_Service_Tag
SET "REGISTRY_TAG=%~1"
FOR /f "tokens=*" %%i IN ('reg query "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\%SERVICE_NAME%" /v %REGISTRY_TAG%') DO (
    SET "QUERY_RESULT=%%i"
    SET "TARGET_RESULT=!QUERY_RESULT:%REGISTRY_TAG%=!"
    IF NOT "!TARGET_RESULT!"=="!QUERY_RESULT!" (
        FOR /F "tokens=2*" %%a IN ("%%i") DO (
            SET "SUB_RESULT=%%b"
            IF NOT ""=="!SUB_RESULT!" (
                SET "FIRST_CHAR=!SUB_RESULT:~0,1!"
                SET "LAST_CHAR=!SUB_RESULT:~-1!"
                IF NOT ^"==!FIRST_CHAR! (
                    IF NOT ^"==!LAST_CHAR! (
                        SET SUB_RESULT="!SUB_RESULT!"
                    )
                )
                REM ECHO SUB_RESULT=!SUB_RESULT!
                CALL :Sub_Left_Trim !SUB_RESULT! %~2
            )
        )
        GOTO Sub_Query_Service_Tag_Exit
    )
)
:Sub_Query_Service_Tag_Exit
GOTO:EOF

REM ------------------------------------------------
:Sub_Query_Nfs
SET "TAG_QUERY_SERVER_STATUS_NOT_ACCESSIBLE=NotAccessible"
SET "TAG_QUERY_SERVER_STATUS_STARTED=Started"
SET "TAG_QUERY_SERVER_STATUS_STOPPED=Stopped"
SET "TAG_QUERY_SERVER_VERSION=Server Version:"
SET "TAG_QUERY_SERVER_STATUS=Server Status:"
SET "TAG_QUERY_SERVER_NUM_MOUNT_POINT=Number of Mount Point:"
SET "TAG_QUERY_SERVER_NUM_SESSION=Number of Session:"

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
    SET "NFS_EXE=nfsX86.exe"
) ELSE (
    SET "NFS_EXE=nfsX64.exe"
)
FOR /f "tokens=*" %%i IN ('"%NFS_EXE%" -console -query') DO (
    CALL :Sub_Query_Nfs_Parser "%%i"
)

:Sub_Query_Nfs_End
GOTO:EOF

REM ------------------------------------------------
:Sub_Query_Nfs_Parser
SET "QUERY_RESULT=%~1"
SET "QUERY_CHECK=!QUERY_RESULT:%TAG_QUERY_SERVER_VERSION%=!"
IF NOT "!QUERY_CHECK!"=="!QUERY_RESULT!" (
    CALL :Sub_Left_Trim "!QUERY_CHECK!" NFS_VERSION
    GOTO Sub_Query_Nfs_Parser_Exit
)
SET "QUERY_CHECK=!QUERY_RESULT:%TAG_QUERY_SERVER_STATUS%=!"
IF NOT "!QUERY_CHECK!"=="!QUERY_RESULT!" (
    CALL :Sub_Left_Trim "!QUERY_CHECK!" QUERY_CHECK
    IF "!QUERY_CHECK!"=="%TAG_QUERY_SERVER_STATUS_NOT_ACCESSIBLE%" (
        SET "NFS_STATUS=%TAG_STATUS_NOT_ACCESSIBLE%"
        GOTO Sub_Query_Nfs_Parser_Exit
    )
    IF "!QUERY_CHECK!"=="%TAG_QUERY_SERVER_STATUS_STARTED%" (
        SET "NFS_STATUS=%TAG_STATUS_RUNNING%"
        GOTO Sub_Query_Nfs_Parser_Exit
    )
    IF "!QUERY_CHECK!"=="%TAG_QUERY_SERVER_STATUS_STOPPED%" (
        SET "NFS_STATUS=%TAG_STATUS_STOPPED%"
        GOTO Sub_Query_Nfs_Parser_Exit
    )    
    REM un-defined status
    SET "NFS_STATUS=!QUERY_CHECK!"
    GOTO Sub_Query_Nfs_Parser_Exit
)
SET "QUERY_CHECK=!QUERY_RESULT:%TAG_QUERY_SERVER_NUM_MOUNT_POINT%=!"
IF NOT "!QUERY_CHECK!"=="!QUERY_RESULT!" (
    CALL :Sub_Left_Trim "!QUERY_CHECK!" NFS_NUM_MOUNT_POINT
    GOTO Sub_Query_Nfs_Parser_Exit
)
SET "QUERY_CHECK=!QUERY_RESULT:%TAG_QUERY_SERVER_NUM_SESSION%=!"
IF NOT "!QUERY_CHECK!"=="!QUERY_RESULT!" (
    CALL :Sub_Left_Trim "!QUERY_CHECK!" NFS_NUM_RUNNING_SESSION
    GOTO Sub_Query_Nfs_Parser_Exit
)
REM un-defined result, ignore in here

:Sub_Query_Nfs_Parser_Exit
GOTO:EOF
